% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn_domain_score.R
\name{knn_domain_score}
\alias{knn_domain_score}
\title{Calculate the K-Nearest Neighbor model domain applicability score}
\usage{
knn_domain_score(
  featured_col,
  train_data,
  knn_hyperparameters,
  test_data,
  threshold_value
)
}
\arguments{
\item{featured_col}{The name of the response variable to predict.}

\item{train_data}{The training dataset containing predictor variables and the response variable.}

\item{knn_hyperparameters}{A list of hyperparameters for the KNN model, including:
\itemize{
\item \code{neighbors}: The number of neighbors to consider.
\item \code{weight_func}: The weight function to use.
\item \code{dist_power}: The distance power parameter.
}}

\item{test_data}{The test dataset for making predictions.}

\item{threshold_value}{The threshold value used for computing domain scores.}
}
\value{
A data frame containing the computed domain scores for each observation in the test dataset.
}
\description{
This function fits a K-Nearest Neighbor (KNN) model to the provided data
and computes a domain applicability score based on PCA distances.
}
\examples{
set.seed(123)
library(dplyr)
featured_col <- "cd_2022"
# Specifying features for training and testing procedures
train_data = viral |>
  dplyr::select(cd_2022, vl_2022)
test_data = sero 
knn_hyperparameters <- list(neighbors = 5, weight_func = "optimal", dist_power = 0.3304783)
threshold_value <- 0.99
# Call the function
}
