% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cd_fit.R
\name{cd_fit}
\alias{cd_fit}
\title{Fit and Evaluate Stacked Ensemble Model for CD4 Cell Count or Viral Load Outcome}
\usage{
cd_fit(
  outcome,
  traindata,
  viralvars,
  logbase,
  seed,
  repetitions,
  gridsize,
  testdata,
  predicted
)
}
\arguments{
\item{outcome}{The name of the outcome variable.}

\item{traindata}{The training dataset used for building the ensemble.}

\item{viralvars}{A vector of variable names representing viral variables.}

\item{logbase}{The base for the logarithmic transformation in preprocessing.}

\item{seed}{Seed for reproducibility.}

\item{repetitions}{Number of repetitions for cross-validation.}

\item{gridsize}{Number of grid points for hyperparameter tuning.}

\item{testdata}{The test dataset for evaluating the ensemble.}

\item{predicted}{Column name of the predicted variable in a regression tidy format.}
}
\value{
A tibble containing the root mean squared error (RMSE) and coefficient of determination (R2) metrics.
}
\description{
This function builds a stacked ensemble model using various preprocessing and modeling workflows.
}
\examples{
\donttest{
library(baguette)
library(kernlab)
library(kknn)
library(ranger)
library(rules)
data("cd_train", package = "viruslearner")
data("cd_test", package = "viruslearner")
outcome <- "cd_2023"
traindata <- cd_train
viralvars <- c("vl_2019", "vl_2021", "vl_2022", "vl_2023")
logbase <- 10
seed <- 1501
repetitions <- 2
gridsize <- 1
testdata <- cd_test
predicted <- ".pred"
cd_fit(outcome, traindata, viralvars, logbase, seed, repetitions, gridsize, testdata, predicted)
}
}
