% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visTable.R
\name{visTable}
\alias{visTable}
\title{Generate a formatted table from a \verb{<data.table>}}
\usage{
visTable(
  result,
  estimateName = character(),
  header = character(),
  groupColumn = character(),
  rename = character(),
  type = "gt",
  hide = character(),
  .options = list()
)
}
\arguments{
\item{result}{A table to format.}

\item{estimateName}{A named list of estimate names to join, sorted by
computation order. Use \verb{<...>} to indicate estimate names. This argument
requires that the table has \code{estimate_name} and \code{estimate_value} columns.}

\item{header}{A vector specifying the elements to include in the header.
The order of elements matters, with the first being the topmost header.
The vector elements can be column names or labels for overall headers.
The table must contain an \code{estimate_value} column to pivot the headers.}

\item{groupColumn}{Columns to use as group labels. By default, the name of the
new group will be the tidy* column names separated by ";". To specify a custom
group name, use a named list such as:
list("newGroupName" = c("variable_name", "variable_level")).

*tidy: The tidy format applied to column names replaces "_" with a space and
converts them to sentence case. Use \code{rename} to customise specific column names.}

\item{rename}{A named vector to customise column names, e.g.,
c("Database name" = "cdm_name"). The function will rename all column names
not specified here into a tidy* format.}

\item{type}{The desired format of the output table. See \code{tableType()} for
allowed options.}

\item{hide}{Columns to drop from the output table.}

\item{.options}{A named list with additional formatting options.
\code{visOmopResults::tableOptions()} shows allowed arguments and their default values.}
}
\value{
A tibble, gt, or flextable object.
}
\description{
This function combines the functionalities of \code{formatEstimateValue()},
\code{formatEstimateName()}, \code{formatHeader()}, and \code{formatTable()}
into a single function. While it does not require the input table to be
a \verb{<summarised_result>}, it does expect specific fields to apply some
formatting functionalities.
}
\examples{
result <- mockSummarisedResult()
result |>
  visTable(
    estimateName = c("N\%" = "<count> (<percentage>)",
                     "N" = "<count>",
                     "Mean (SD)" = "<mean> (<sd>)"),
    header = c("Estimate"),
    rename = c("Database name" = "cdm_name"),
    groupColumn = c("strata_name", "strata_level"),
    hide = c("additional_name", "additional_level", "estimate_type", "result_type")
  )
}
