% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sr.R
\name{sr}
\alias{sr}
\alias{nsr}
\alias{lm.sr}
\alias{lm.nsr}
\title{Calculate Simple Ratio (SR).}
\usage{
sr(s, b1, b2)

nsr(s, b1, b2)

lm.sr(s, b1, b2, y)

lm.nsr(s, b1, b2, y)
}
\arguments{
\item{s}{Spectral data in the format of visa's Spectra object, spectra.data.frame or spectra.matrix.}

\item{b1}{A integer number which defines the wavelength of the 1st spectral band.}

\item{b2}{A integer number which defines the wavelength of the 2nd spectral band.}

\item{y}{A numeric variable to correlate with SR}
}
\value{
\item{sr}{Returns a simple ratio index.}

\item{nsr}{Returns a NSR index.}

\item{p}{Returns a ggplot object.}

\item{p}{Returns a ggplot object.}
}
\description{
Simple Ratio is the ratio of the spectra (mostly reflectance) between two bands
in the format of \deqn{SR = \lambda_i/\lambda_j}

It is a normalization of SR by doing NSR = (1-SR)/(1+SR), with the same two spectral bands.
}
\details{
Simple ratio and NDVI looking indices are the two groups of mostly used spectral indices in remote sensing.

As it exactly reads in its name, it is a normalization of the SR and ranges in (0,1).
}
\examples{
library(visa)
s <- NSpec.DF$spectra
sr1 <- sr(s, 480, 550)

s <- NSpec.DF$spectra
nsr1 <- nsr(s, 480, 550)

s <- NSpec.DF
y <- NSpec.DF$N
lm.sr(s,600,500,y)

s <- NSpec.DF
y <- NSpec.DF$N
lm.nsr(s,600,500,y)

}
