% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_subplots.R
\name{set_subplots}
\alias{set_subplots}
\title{Find correct subplot for ranges and events}
\usage{
set_subplots(data)
}
\arguments{
\item{data}{the data frame with ranges and events}
}
\value{
data with additional numeric column "subplot", reordered by subplot column.
}
\description{
For technical reasons (plotly), ranges and events need different subplots. We are still trying to keep events and ranges that are in the same group together.
We determine the subplot as follows: Groups appear in order of appearance in the data, events and ranges in the same group are plotted directly below each other
}
\examples{
\dontrun{
set_subplots(data.frame(
  event = 1:4, start = c("2019-01-01", "2019-01-10"),
  end = c("2019-01-01", "2019-01-10"), group = ""
), stringsAsFactors = F)
set_subplots(data.frame(
  event = 1:4, start = c("2019-01-01", "2019-01-10"),
  end = c("2019-01-01", "2019-01-10"), group = 1:2
), stringsAsFactors = F)
set_subplots(data.frame(
  event = 1:3, start = c("2019-01-01", "2019-01-10", "2019-01-01"),
  end = c("2019-01-10", "2019-01-20", "2019-01-10"),
  group = c(1, 2, 1), stringsAsFactors = F
))
}
}
