% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vistime_data.R
\name{vistime_data}
\alias{vistime_data}
\title{Standardize data to plot on a timeline plot}
\usage{
vistime_data(
  data,
  events = "event",
  start = "start",
  end = "end",
  groups = "group",
  colors = "color",
  fontcolors = "fontcolor",
  tooltips = "tooltip",
  optimize_y = TRUE
)
}
\arguments{
\item{data}{\code{data.frame} that contains the data to be visualised}

\item{events}{(optional, character) the column name in \code{data} that contains event
names. Default: \emph{event}.}

\item{start}{(optional, character) the column name in \code{data} that contains start
dates. Default: \emph{start}.}

\item{end}{(optional, character) the column name in \code{data} that contains end dates.
Default: \emph{end}.}

\item{groups}{(optional, character) the column name in \code{data} to be used for
grouping. Default: \emph{group}.}

\item{colors}{(optional, character) the column name in \code{data} that contains colors
for events. Default: \emph{color}, if not present, colors are chosen via
\code{RColorBrewer}.}

\item{fontcolors}{(optional, character) the column name in \code{data} that contains the
font color for event labels. Default: \emph{fontcolor}, if not present,
color will be black.}

\item{tooltips}{(optional, character) the column name in \code{data} that contains the
mouseover tooltips for the events. Default: \emph{tooltip}, if not present,
then tooltips are build from event name and date.}

\item{optimize_y}{(optional, logical) distribute events on y-axis by smart heuristic (default), otherwise use order of input data.}
}
\value{
\code{vistime_data} returns a data.frame with the following columns: event, start, end, group, tooltip, label, col, fontcol, subplot, y
}
\description{
Standardize data to plot on a timeline plot
}
\examples{
# presidents and vice presidents
pres <- data.frame(
  Position = rep(c("President", "Vice"), each = 3),
  Name = c("Washington", rep(c("Adams", "Jefferson"), 2), "Burr"),
  start = c("1789-03-29", "1797-02-03", "1801-02-03"),
  end = c("1797-02-03", "1801-02-03", "1809-02-03"),
  color = c("#cbb69d", "#603913", "#c69c6e"),
  fontcolor = c("black", "white", "black")
)

vistime_data(pres, events = "Position", groups = "Name")
}
