% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_hist.R
\name{create_hist}
\alias{create_hist}
\title{Create a histogram plot for any metric}
\usage{
create_hist(
  data,
  metric,
  hrvar = "Organization",
  mingroup = 5,
  binwidth = 1,
  ncol = NULL,
  return = "plot"
)
}
\arguments{
\item{data}{A Standard Person Query dataset in the form of a data frame.}

\item{metric}{String containing the name of the metric,
e.g. "Collaboration_hours"}

\item{hrvar}{String containing the name of the HR Variable by which to split
metrics. Defaults to \code{"Organization"}. To run the analysis on the total
instead of splitting by an HR attribute, supply \code{NULL} (without quotes).}

\item{mingroup}{Numeric value setting the privacy threshold / minimum group
size. Defaults to 5.}

\item{binwidth}{Numeric value for setting \code{binwidth} argument within
\code{ggplot2::geom_histogram()}. Defaults to 1.}

\item{ncol}{Numeric value setting the number of columns on the plot. Defaults
to \code{NULL} (automatic).}

\item{return}{String specifying what to return. This must be one of the
following strings:
\itemize{
\item \code{"plot"}
\item \code{"table"}
\item \code{"data"}
\item \code{"frequency"}
}

See \code{Value} for more information.}
}
\value{
A different output is returned depending on the value passed to the \code{return}
argument:
\itemize{
\item \code{"plot"}: 'ggplot' object. A faceted histogram for the metric.
\item \code{"table"}: data frame. A summary table for the metric.
\item \code{"data"}: data frame. Data with calculated person averages.
\item \verb{"frequency}: list of data frames. Each data frame contains the
frequencies used in each panel of the plotted histogram.
}
}
\description{
Provides an analysis of the distribution of a selected metric.
Returns a faceted histogram by default.
Additional options available to return the underlying frequency table.
}
\examples{
# Return plot for whole organization
create_hist(pq_data, metric = "Collaboration_hours", hrvar = NULL)

# Return plot
create_hist(pq_data, metric = "Collaboration_hours", hrvar = "Organization")

# Return plot but coerce plot to 3 columns
create_hist(pq_data, metric = "Collaboration_hours", hrvar = "Organization", ncol = 3)

# Return summary table
create_hist(pq_data,  metric = "Collaboration_hours", hrvar = "Organization", return = "table")
}
\seealso{
Other Flexible: 
\code{\link{create_bar_asis}()},
\code{\link{create_bar}()},
\code{\link{create_boxplot}()},
\code{\link{create_bubble}()},
\code{\link{create_density}()},
\code{\link{create_dist}()},
\code{\link{create_fizz}()},
\code{\link{create_inc}()},
\code{\link{create_line_asis}()},
\code{\link{create_line}()},
\code{\link{create_period_scatter}()},
\code{\link{create_rank}()},
\code{\link{create_scatter}()},
\code{\link{create_stacked}()},
\code{\link{create_tracking}()},
\code{\link{create_trend}()}
}
\concept{Flexible}
