% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_g2g.R
\name{network_g2g}
\alias{network_g2g}
\title{Create a network plot with the group-to-group query}
\usage{
network_g2g(
  data,
  primary = NULL,
  secondary = NULL,
  metric = "Group_collaboration_time_invested",
  algorithm = "fr",
  node_colour = "lightblue",
  exc_threshold = 0.1,
  org_count = NULL,
  subtitle = "Collaboration Across Organizations",
  return = "plot"
)
}
\arguments{
\item{data}{Data frame containing a group-to-group query.}

\item{primary}{String containing the variable name for the Primary
Collaborator column.}

\item{secondary}{String containing the variable name for the Secondary
Collaborator column.}

\item{metric}{String containing the variable name for metric. Defaults to
\code{Group_collaboration_time_invested}.}

\item{algorithm}{String to specify the node placement algorithm to be used.
Defaults to \code{"fr"} for the force-directed algorithm of Fruchterman and
Reingold. See
\url{https://rdrr.io/cran/ggraph/man/layout_tbl_graph_igraph.html} for a full
list of options.}

\item{node_colour}{String or named vector to specify the colour to be used
for displaying nodes. Defaults to \code{"lightblue"}.
\itemize{
\item If \code{"vary"} is supplied, a different colour is shown for each node at
random.
\item If a named vector is supplied, the names must match the values of the
variable provided for the \code{primary} and \code{secondary} columns. See
example section for details.
}}

\item{exc_threshold}{Numeric value between 0 and 1 specifying the exclusion
threshold to apply. Defaults to 0.1, which means that the plot will only
display collaboration above 10\% of a node's total collaboration. This
argument has no impact on \code{"data"} or \code{"table"} return.}

\item{org_count}{Optional data frame to provide the size of each organization
in the \code{secondary} attribute. The data frame should contain only two
columns:
\itemize{
\item Name of the \code{secondary} attribute excluding any prefixes, e.g.
\code{"Organization"}. Must be of character or factor type.
\item \code{"n"}. Must be of numeric type.
Defaults to \code{NULL}, where node sizes will be fixed.
}}

\item{subtitle}{String to override default plot subtitle.}

\item{return}{String specifying what to return. This must be one of the
following strings:
\itemize{
\item \code{"plot"}
\item \code{"table"}
\item \code{"network"}
\item \code{"data"}
}

See \code{Value} for more information.}
}
\value{
A different output is returned depending on the value passed to the \code{return}
argument:
\itemize{
\item \code{"plot"}: 'ggplot' object. A group-to-group network plot.
\item \code{"table"}: data frame. An interactive matrix of the network.
\item \verb{"network}: 'igraph' object used for creating the network plot.
\item \code{"data"}: data frame. A long table of the underlying data.
}
}
\description{
Pass a data frame containing a group-to-group query and return a network
plot. Automatically handles \code{"Within Group"} and \code{"Other_collaborators"}
values within query data.
}
\examples{
# Return a network plot
g2g_data \%>\% network_g2g()

# Return a network plot - Meeting hours and 5\% threshold
network_g2g(
  data = g2g_data,
  primary = "PrimaryCollaborator_Organization",
  secondary = "SecondaryCollaborator_Organization",
  exc_threshold = 0.05
)

# Return a network plot - custom-specific colours
# Get labels of orgs and assign random colours
org_str <- unique(g2g_data$PrimaryCollaborator_Organization)

col_str <-
  sample(
    x = heat_colours(n = length(org_str)), # generate colour codes for each one
    size = length(org_str),
    replace = TRUE
  )

# Create and supply a named vector to `node_colour`
names(col_str) <- org_str

g2g_data \%>\%
  network_g2g(node_colour = col_str)


# Return a network plot with circle layout
# Vary node colours and add org sizes
org_tb <-
  data.frame(
    Organization = c(
      "G&A East",
      "G&A West",
      "G&A North",
      "South Sales",
      "North Sales",
      "G&A South"
    ),
    n = sample(30:1000, size = 6)
  )

g2g_data \%>\%
  network_g2g(algorithm = "circle",
              node_colour = "vary",
              org_count = org_tb)

# Return an interaction matrix
# Minimum arguments specified
g2g_data \%>\%
  network_g2g(return = "table")

}
\seealso{
Other Network: 
\code{\link{g2g_data}},
\code{\link{network_p2p}()},
\code{\link{network_summary}()},
\code{\link{p2p_data}},
\code{\link{p2p_data_sim}()}
}
\concept{Network}
