% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/status.R
\name{getStatus}
\alias{getStatus}
\title{Returns data required to show the status of a users and/or communities}
\usage{
getStatus(users_ids = c(), groups_ids = c(), progress_bar = FALSE,
  v = getAPIVersion())
}
\arguments{
\item{users_ids}{User IDs}

\item{groups_ids}{Community IDs}

\item{progress_bar}{Display progress bar}

\item{v}{Version of API}
}
\description{
Returns data required to show the status of a users and/or communities
}
\examples{
\dontrun{
status.me <- getStatus()
status.friends <- getStatus(users_ids = getFriends()$items)
status.groups  <- getStatus(groups_ids = getGroups()$items)
status.friends_and_groups <- getStatus(users_ids = getFriends()$items,
 groups_ids = getGroups()$items, progress_bar = T)
}
}

