% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racusum_sim.R
\name{racusum_arl_sim}
\alias{racusum_arl_sim}
\title{Compute ARLs of RA-CUSUM control charts using simulation}
\usage{
racusum_arl_sim(r, pmix, h, RA = 2, RQ = 1, yemp = FALSE)
}
\arguments{
\item{r}{Integer Vector. Number of runs.}

\item{pmix}{Data Frame. A three column data frame. First column is the operation outcome.
Second column are the predicted probabilities from the risk model. Third column can be either the
 predicted probabilities from the risk model or average outcome.}

\item{h}{Double. Control Chart limit for detecting deterioration/improvement.}

\item{RA}{Double. Odds ratio of death under the alternative hypotheses. Detecting deterioration
in performance with increased mortality risk by doubling the odds Ratio \code{RA = 2}. Detecting
 improvement in performance with decreased mortality risk by halving the odds ratio of death
 \code{RA = 1/2}. Odds ratio of death under the null hypotheses is \code{1}.}

\item{RQ}{Double. Defines the true performance of a surgeon with the odds ratio ratio of death
\code{RQ}. Use \code{RQ = 1} to compute the in-control ARL and other values to compute the
out-of-control ARL.}

\item{yemp}{Logical. If \code{TRUE} use observed outcome value, if \code{FALSE} use estimated
binary logistc regression model.}
}
\value{
Returns a single value which is the Run Length.
}
\description{
Computes the Average Run Length of a risk-adjusted cumulative sum control chart
 using simulation.
}
\examples{
\dontrun{
library(vlad)
library(dplyr)
data("cardiacsurgery", package = "spcadjust")

set.seed(1234)
SALLI <- cardiacsurgery \%>\% mutate(s = Parsonnet) \%>\%
  mutate(y = ifelse(status == 1 & time <= 30, 1, 0),
         phase = factor(ifelse(date < 2*365, "I", "II"))) \%>\%
  filter(phase == "I") \%>\% select(s, y)

## estimate risk model, get relative frequences and probabilities
mod1 <- glm(y ~ s, data = SALLI, family = "binomial")
y <- SALLI$y
pi1 <- fitted.values(mod1)

## set up patient mix (risk model)
pmix <- data.frame(y, pi1, pi1)
h <- 2.75599

m <- 1e4
RLS <- sapply(1:m, racusum_arl_sim, h=h, pmix=pmix, RA=2)
data.frame(cbind(ARL=mean(RLS), ARLSE=sd(RLS)/sqrt(m), h, m))
}
}
\references{
Steiner SH, Cook RJ, Farewell VT and Treasure T (2000).
 Monitoring surgical performance using risk-adjusted cumulative sum charts.
 \emph{Biostatistics}, \strong{1}(4), pp. 441--452.

Wittenberg P, Gan FF, Knoth S (2018).
A simple signaling rule for variable life-adjusted display derived from
an equivalent risk-adjusted CUSUM chart.
\emph{Statistics in Medicine}, \strong{37}(16), pp 2455--2473.
}
\author{
Philipp Wittenberg
}
