% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vlda_add.R
\name{vlda_add}
\alias{vlda_add}
\title{Supplementary Objects and Variables}
\usage{
vlda_add(fit, add.col = NULL, add.row = NULL, time.name = NULL)
}
\arguments{
\item{fit}{An object returned by vlda()}

\item{add.col}{A data matirx, The type of indicator matrix. Additional data sets in column format. \eqn{p \ge 2}}

\item{add.row}{A data matirx, The type of indicator matrix. Additional data sets in row format.
Supplemental data should have the same variable name as \code{fit$ind.mat} returned by \code{\link{vlda}},
and if it is not an indicator matrix, you can use it after generate an indicator matrix using \code{\link{indicator}} function built into vlda.}

\item{time.name}{If supplemental data to add contains a time variable, it requires argument a character string that specifies the name of the time variable.}
}
\value{
\item{...}{Same as the result of vlda}
\item{sup.coordiante}{A tibble data class. The coordinates of the new object created when adding supplemental data to the already provided vlda plot.}
}
\description{
Add objects or variables with new information to the two-dimensional VLDA plot proposed for multidimensional longitudinal data.
}
\details{
The longitudinal data inevitably has the characteristic that supplementary data is added such as: \cr

* Outcome variables measured at additional time points, such as \eqn{T+1, T+2, ...} after the last time point \eqn{T}. \cr
* New objects that are not previously measured.\cr
* Other covariates that indicate the characteristics of objects.\cr

Find coordinates representing objects and variables that are added in the VLDA plot already
provided, through a method obtain that find coordinates on low-dimensional space for supplementary elements.
}
\examples{
#### Supplementary row and column indicator matrix added ####
### long form ###
data(PTSD)
PTSD <- as.data.frame(PTSD)
PTSD[,2:4] <- apply(PTSD[,2:4], 2, function(x) ifelse(x >= 3, 1, 0))
PTSD[,5] <-  ifelse(PTSD[,5] >= 6 , 1, 0)
PTSD <- data.frame(lapply(PTSD, function(x) as.factor(x)))
fit <- vlda(x = PTSD, object = "subject", time = "time", type = "long")

data(PTSD_column) # The degree of drinking that may affect PTSD
PTSD_column <- as.matrix(PTSD_column)

data(PTSD_row) # Added to the row, and is intended for 316 patients after 18 months.
PTSD_row <- as.matrix(PTSD_row)


vlda_add(
fit,
add.row = PTSD_row,
add.col = PTSD_column
)


### Wide form ###
data(Depression)
fit2 <- vlda(x = Depression, object = "Case", time = c("1week", "2weeks", "4weeks"), type = "wide")

# Response after 6 weeks and gender were added the columns for 800 existing patients.
data(Depression_column) 
Depression_column <- as.matrix(Depression_column)

# 100 patients who took placebo in each group of mild and severe were added to the rows.
data(Depression_row) 
Depression_row <- as.matrix(Depression_row)


vlda_add(
fit2,
time.name = "6weeks",
add.row = Depression_row,
add.col = Depression_column
)


}
\seealso{
\code{vlda}
}
\keyword{Supplement}
