% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{auth_twitter_user}
\alias{auth_twitter_user}
\title{Twitter User API authentication}
\usage{
auth_twitter_user(api_key, api_secret, verbose = FALSE, ...)
}
\arguments{
\item{api_key}{Character string. API consumer key to authenticate (also called API key).}

\item{api_secret}{Character string. API consumer secret to authenticate (also called API secret).}

\item{verbose}{Logical. Output additional information. Default is \code{FALSE}.}

\item{...}{Additional parameters passed to function. Not used in this method.}
}
\value{
A \code{credential} object containing an access token \code{$auth} and social media type descriptor
\code{$socialmedia} set to \code{"twitter"}. Object has the class names \code{"credential"} and \code{"twitter"}.
}
\description{
A method commonly used by third-party apps in which an app can be authorized by a user to use the
twitter API on their behalf. The implementation of this method in \pkg{vosonSML} does not require a developer
account but does still require the user to have access to an apps two consumer API keys (generated by the app
developer). The authentication object with token produced from this method allows the user to access the API within
their own user-context and rate-limits.
}
\note{
\pkg{vosonSML} uses the \pkg{rtweet} package for twitter data collection and also gratefully acknowledges the
techniques and code written by its authors reproduced in this package for creating twitter API access tokens.
}
\examples{
\dontrun{
# twitter user authentication via authorization of an app requires the
# apps consumer API keys (api_key and api_secret)
# this method will open a web browser to twitter prompting the user to
# log in and authorize the app
auth <- auth_twitter_user(
  api_key = "xxxxxxxxxxxx", api_secret = "xxxxxxxxxxxx"
)
}

}
