% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{generate_spatial}
\alias{generate_spatial}
\title{Generate spatial simulation}
\usage{
generate_spatial(
  n_voters,
  n_candidates,
  placement = "uniform",
  score_method = "linear",
  dim = 2
)
}
\arguments{
\item{n_voters}{The number of voters.}

\item{n_candidates}{The number of candidates.}

\item{placement}{The method used to place the candidates on the 2-dimensional plane. Must be either "uniform" or "beta". Default is "uniform".}

\item{score_method}{The method used to transform distances into scores. Must be either "linear" or "sigmoide". Default is "linear".}

\item{dim}{The dimension of the latent space (by default dim =2)}
}
\value{
A matrix of scores.
}
\description{
This function generates spatial data consisting of \code{n_voters} voters and \code{n_candidates} candidates. The spatial model is created by placing the candidates on a 2-dimensional plane according to the \code{placement} parameter, and then computing a distance matrix between voters and candidates. The distances are then transformed into scores using the \code{score_method} parameter. Finally, a plot of the candidates and voters is produced.
}
\examples{
generate_spatial(n_candidates = 5,n_voters = 100,  placement = "uniform", score_method = "linear")
}
