% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/square_window.R
\name{square_windowc}
\alias{square_windowc}
\title{Build a square windows variable, categorical target.}
\usage{
square_windowc(varName, x, y, w = NULL)
}
\arguments{
\item{varName}{character, name of variable}

\item{x}{numeric input (not empty, no NAs).}

\item{y}{numeric or castable to such (same length as x no NAs), output to match}

\item{w}{numeric positive, same length as x (weights, can be NULL) IGNORED}
}
\value{
segmented y prediction
}
\description{
Build a square moving average window (KNN in 1d).  This is a high-frequency feature.
Approximation of the change in log odds.
}
\examples{

d <- data.frame(x = c(NA, 1:6), y = c(0, 0, 0, 1, 1, 0, 0))
square_window("v", d$x, d$y)


}
