% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/return_assertions_message.R
\name{check_zero_columns}
\alias{check_zero_columns}
\title{Check for Columns with Only 0s}
\usage{
check_zero_columns(dataframe, collection)
}
\arguments{
\item{dataframe}{A dataframe.}

\item{collection}{A list to store the names of the columns with only 0 values.}
}
\value{
The updated collection.
}
\description{
This function checks if there are any columns in the provided dataframe that contain only 0 values.
If such columns exist, their names are added to the provided collection.
}
\examples{
# Create a dataframe with some columns containing only 0 values
dataframe <- data.frame(a = c(0, 0, 0), b = c(1, 2, 3), c = c(0, 0, 0))
collection <- checkmate::makeAssertCollection()
check_zero_columns(dataframe, collection)
}
