% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_tags_to_workbook.R
\name{add_tags_to_workbook}
\alias{add_tags_to_workbook}
\title{Add tags to a workbook in Tableau Server.}
\usage{
add_tags_to_workbook(tableau, api_version = 3.8, workbook_id, tags)
}
\arguments{
\item{tableau}{A list containing the Tableau authentication variables: `base_url`, `token`, `user_id`, and `site_id`.}

\item{api_version}{The API version to use (default: 3.8).}

\item{workbook_id}{The ID of the workbook to add tags to.}

\item{tags}{A vector of tags to add to the workbook.}
}
\value{
The response from the API.
}
\description{
Adds one or more tags to the specified workbook in the Tableau Server using the provided authentication credentials.
}
\seealso{
Other Tableau REST API: 
\code{\link{add_tags_to_view}()},
\code{\link{add_user_to_group}()},
\code{\link{add_user_to_site}()},
\code{\link{authenticate_PAT}()},
\code{\link{authenticate_server}()},
\code{\link{create_group}()},
\code{\link{delete_group}()},
\code{\link{download_datasource}()},
\code{\link{download_filtered_tableau_image}()},
\code{\link{download_tableau_crosstab_excel}()},
\code{\link{download_tableau_data}()},
\code{\link{download_workbooks_server_pdf}()},
\code{\link{download_workbooks_server_powerpoint}()},
\code{\link{download_workbooks_server}()},
\code{\link{get_groups_for_user}()},
\code{\link{get_mobile_security_settings}()},
\code{\link{get_server_connected_apps}()},
\code{\link{get_server_datasources}()},
\code{\link{get_server_groups}()},
\code{\link{get_server_info}()},
\code{\link{get_server_jobs}()},
\code{\link{get_server_projects}()},
\code{\link{get_server_refresh_tasks}()},
\code{\link{get_server_schedules}()},
\code{\link{get_server_user_favorites}()},
\code{\link{get_server_users}()},
\code{\link{get_server_views}()},
\code{\link{get_server_workbooks}()},
\code{\link{get_table_assets}()},
\code{\link{get_users_in_group}()},
\code{\link{query_user_on_site}()},
\code{\link{remove_user_from_group}()},
\code{\link{remove_user_from_site}()},
\code{\link{update_group}()},
\code{\link{update_user}()}
}
\concept{Tableau REST API}
