% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetVis.R
\name{NetVis}
\alias{NetVis}
\title{NetVis}
\usage{
NetVis(input_vis, cutoff = list(kind = "Threshold", value = 0.5),
  layout = NULL, smooth.edges = T, path = NULL, Cluster = F,
  legend = T, shape = list(shape = "triangle", names = NULL),
  manipulation = F)
}
\arguments{
\item{input_vis}{Network to be plotted. It's usually an output from the wTO.Complete or Consensus.}

\item{cutoff}{It's a list containing the kind of cutoff to be used (pval, Threshold or pval.adj)and it's value. Example: cutoff= list(kind = "Threshold", value = 0.5)}

\item{layout}{a layout from the igraph package.}

\item{smooth.edges}{If the edges should be smoothed or not.}

\item{path}{If the graph should be saved specify the name of the file.}

\item{Cluster}{TRUE or FALSE if the nodes should be clustered (double click to uncluster).}

\item{legend}{TRUE or FALSE if the legend should appear.}

\item{shape}{a list shape=list(shape = "triangle", names = NULL), with the shape and the IDs that should have a different shape, shape can be: diamond, star, triangle, triangleDown or square.}

\item{manipulation}{TRUE or FALSE if the graph should be editable.}
}
\description{
Given a set of Nodes and the weight of the edges, a cutoff for the edges, it draws the networks. Returns a list with the nodes and edges  attributes. And plots the network.
}
\examples{

 EXAMPLE =  wTO.Complete( k =2, n = 10, Data = ExampledfExpression,
 Overlap = ExampleGRF$x, method = "p")
# Plot with the default aguments.
 x = NetVis(EXAMPLE$wTO, cutoff= list(kind = "Threshold", value = 0.5))
 x$network

\dontrun{
# Plotting just the edges with p-value < 0.05, with straight edges, nodes clustered,
# no legend and mapipulation of the graph enabled.
 x = NetVis(EXAMPLE$wTO, cutoff= list(kind = "pval", value = 0.05),
  smooth.edges = FALSE,
 Cluster = TRUE, legend = FALSE, manipulation = TRUE)
# Plotting just the edges with wTO > 0.50, no legend and the nodes:
# "ZNF738", "ZNF677" with triagle shape,
# no legend and mapipulation of the graph enabled.
 x = NetVis(EXAMPLE$wTO, cutoff= list(kind = "Threshold", value = 0.5),legend = FALSE,
 shape = list(shape = "triangle", names = c("ZNF738", "ZNF677")))
 x$network
 }
}
