% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dob.R
\name{dob}
\alias{dob}
\alias{birth}
\title{Generate Random Vector of Birth Dates}
\usage{
dob(n, random = TRUE, x = NULL, start = Sys.Date() - 365 * 15, k = 365 *
  2, by = "1 days", prob = NULL, name = "DOB")

birth(n, random = TRUE, x = NULL, start = Sys.Date() - 365 * 15, k = 365
  * 2, by = "1 days", prob = NULL, name = "Birth")
}
\arguments{
\item{n}{The number elements to generate.  This can be globally set within
the environment of \code{r_data_frame} or \code{r_list}.}

\item{random}{logical.  If \code{TRUE} the dates are randomized, otherwise the
dates are sequential.}

\item{x}{A vector of elements to chose from.  This may be \code{NULL} if
arguments are supplied to \code{start}, \code{k}, and \code{by}.  The
\code{x} argument takes precedence over the other three if \code{!is.null}.
Note that \code{start}, \code{k}, and \code{by} work together to make a
vector of dates to sample from.  See \code{\link[base]{seq.Date}} for
additional information.}

\item{start}{A date to start the sequence at.}

\item{k}{The length of the sequence (number of the elements) so build out from
\code{start}.}

\item{by}{The interval to use in building the sequence.}

\item{prob}{A vector of probabilities to chose from.}

\item{name}{The name to assign to the output vector's \code{varname}
attribute.  This is used to auto assign names to the column/vector name when
used inside of \code{r_data_frame} or \code{r_list}.}
}
\value{
Returns a random vector of birth date elements.
}
\description{
Generate a random vector of birth dates.
}
\examples{
dob(10)
barplot(table(birth(15)))
barplot(table(birth(30)))
}
\seealso{
Other variable functions: \code{\link{age}},
  \code{\link{animal}}, \code{\link{answer}},
  \code{\link{area}}, \code{\link{car}},
  \code{\link{children}}, \code{\link{coin}},
  \code{\link{color}}, \code{\link{date_stamp}},
  \code{\link{death}}, \code{\link{dice}},
  \code{\link{dna}}, \code{\link{dummy}},
  \code{\link{education}}, \code{\link{employment}},
  \code{\link{eye}}, \code{\link{grade_level}},
  \code{\link{grade}}, \code{\link{group}},
  \code{\link{hair}}, \code{\link{height}},
  \code{\link{income}}, \code{\link{internet_browser}},
  \code{\link{iq}}, \code{\link{language}},
  \code{\link{level}}, \code{\link{likert}},
  \code{\link{lorem_ipsum}}, \code{\link{marital}},
  \code{\link{military}}, \code{\link{month}},
  \code{\link{name}}, \code{\link{normal}},
  \code{\link{political}}, \code{\link{race}},
  \code{\link{religion}}, \code{\link{sat}},
  \code{\link{sentence}}, \code{\link{sex_inclusive}},
  \code{\link{sex}}, \code{\link{smokes}},
  \code{\link{speed}}, \code{\link{state}},
  \code{\link{string}}, \code{\link{upper}},
  \code{\link{valid}}, \code{\link{year}},
  \code{\link{zip_code}}
}
\keyword{birth}
\keyword{dob}
