% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/snrspecs.R
\name{snrspecs}
\alias{snrspecs}
\title{Spectrograms with background noise margins}
\source{
\url{https://en.wikipedia.org/wiki/Signal-to-noise_ratio}
}
\usage{
snrspecs(X, wl = 512, flim = c(0, 22), wn = "hanning", pal =
  reverse.gray.colors.2, ovlp = 70, inner.mar = c(5, 4, 4, 2), outer.mar =
  c(0, 0, 0, 0), picsize = 1, res = 100, cexlab = 1, title = TRUE, trel =
  FALSE, propwidth = FALSE, xl=1, osci = FALSE, gr = FALSE, sc = FALSE, mar =
  0.2, snrmar = 0.1, it = "jpeg")
}
\arguments{
\item{X}{Data frame with results from \code{\link{manualoc}} or any data frame with columns
for sound file name (sound.files), selection number (selec), and start and end time of signal
(start and end).}

\item{wl}{A numeric vector of length 1 specifying the window length of the spectrogram, default
is 512.}

\item{flim}{A numeric vector of length 2 for the frequency limit in kHz of
the spectrogram, as in \code{\link[seewave]{spectro}}. Default is c(0, 22).}

\item{wn}{Character vector of length 1 specifying window name. Default is
"hanning". See function \code{\link[seewave]{ftwindow}} for more options.}

\item{pal}{A color palette function to be used to assign colors in the
plot, as in \code{\link[seewave]{spectro}}. Default is reverse.gray.colors.2. See Details.}

\item{ovlp}{Numeric vector of length 1 specifying \% of overlap between two
consecutive windows, as in \code{\link[seewave]{spectro}}. Default is 70.}

\item{inner.mar}{Numeric vector with 4 elements, default is c(5,4,4,2).
Specifies number of lines in inner plot margins where axis labels fall,
with form c(bottom, left, top, right). See \code{\link[graphics]{par}}.}

\item{outer.mar}{Numeric vector with 4 elements, default is c(0,0,0,0).
Specifies number of lines in outer plot margins beyond axis labels, with
form c(bottom, left, top, right). See \code{\link[graphics]{par}}.}

\item{picsize}{Numeric argument of length 1, controls relative size of
spectrogram. Default is 1.}

\item{res}{Numeric argument of length 1 that controls image resolution.
Default is 100 (faster) although 300 - 400 is recommended for publication/
presentation quality.}

\item{cexlab}{Numeric vector of length 1 specifying relative size of axis
labels. See \code{\link[seewave]{spectro}}.}

\item{title}{Logical argument to add a title to individual spectrograms.
Default is \code{TRUE}.}

\item{trel}{Logical argument to add a time axis scale relative to the wave.
Default is \code{FALSE}.}

\item{propwidth}{Logical argument to scale the width of spectrogram
proportionally to duration of the selected call. Default is \code{FALSE}.}

\item{xl}{Numeric vector of length 1, a constant by which to scale
spectrogram width if propwidth = \code{TRUE}. Default is 1.}

\item{osci}{Logical argument to add an oscillogram underneath spectrogram, as
in \code{\link[seewave]{spectro}}. Default is \code{FALSE}.}

\item{gr}{Logical argument to add grid to spectrogram. Default is \code{FALSE}.}

\item{sc}{Logical argument to add amplitude scale to spectrogram, default is
\code{FALSE}.}

\item{mar}{Numeric vector of length 1. Specifies the margins adjacent to the
start and end points of the selections to define spectrogram limits. Default is 0.2.}

\item{snrmar}{Numeric vector of length 1. Specifies the margins adjacent to the start and end
points of the selections where noise will be measured. Default is 0.1.}

\item{it}{A character vector of length 1 giving the image type to be used. Currently only
"tiff" and "jpeg" are admitted. Default is "jpeg".}
}
\value{
Spectrograms per selection marked with margins where background noise will be measured.
}
\description{
\code{snrspecs} creates spectrograms to visualize margins over which background noise
will be measured by \code{\link{sig2noise}}.
}
\details{
This function can be used to test different margins to facilitate
  accurate SNR measurements when using \code{\link{sig2noise}} down the line.
  Setting margins for individual calls that have been previously clipped from
  larger files may take some optimization, as for calls within a
  larger file that are irregularly separated. Setting inner.mar to
  c(4,4.5,2,1) and outer.mar to c(4,2,2,1) works well when picsize = 2 or 3.
  Title font size, inner.mar and outer.mar (from \code{mar} and \code{oma} in \code{par}) don't work well
  when osci or sc = \code{TRUE}, this may take some optimization by the user.
}
\examples{
\dontrun{
# First create empty folder
dir.create(file.path(getwd(),"temp"))
setwd(file.path(getwd(),"temp"))

data(list = c("Phae.long1", "Phae.long2"))
data(manualoc.df)
writeWave(Phae.long1, "Phae.long1.wav") #save sound.files
writeWave(Phae.long2, "Phae.long2.wav")

# make Phae.long1 and Phae.long2 spectrograms
# snrmar needs to be smaller before moving on to sig2noise()

snrspecs(manualoc.df, flim = c(0, 14), inner.mar = c(4,4.5,2,1), outer.mar = c(4,2,2,1),
picsize = 2, res = 300, cexlab = 2, mar = 0.2, snrmar = 0.1, it = "jpeg")

# make only Phae.long1 spectrograms
# snrmar now doesn't overlap neighboring signals

snrspecs(manualoc.df[grepl(c("Phae.long1"), manualoc.df$sound.files), ], flim = c(3, 14),
inner.mar = c(4,4.5,2,1), outer.mar = c(4,2,2,1), picsize = 2, res = 300, cexlab = 2,
mar = 0.2, snrmar = 0.01)

#check this folder!!
getwd()

#remove example directory
unlink(getwd(),recursive = TRUE)
}
}
\author{
Marcelo Araya-Salas (\url{http://marceloarayasalas.weebly.com/}) and Grace Smith Vidaurre
}
\seealso{
\code{\link{trackfreqs}} for creating spectrograms to visualize
  frequency measurements by \code{\link{specan}}, \code{\link{specreator}} for
  creating spectrograms after using \code{\link{manualoc}}

Other spectrogram.creators: \code{\link{specreator}};
  \code{\link{trackfreqs}}
}

