% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mp32wav.R
\name{mp32wav}
\alias{mp32wav}
\title{Convert .mp3 files to .wav}
\usage{
mp32wav(samp.rate = NULL, parallel = 1, path = NULL, 
 dest.path = NULL, bit.depth = 16, pb = TRUE, overwrite = FALSE)
}
\arguments{
\item{samp.rate}{Sampling rate in kHz at which the .wav files should be written. If not provided the sample rate of the original .mp3 file is used. THIS FEATURE IS CURRENTLY NOT AVAILABLE. However, downsampling can be done after .mp3's have been converted using the \code{\link{fix_wavs}} function (which uses \href{http://sox.sourceforge.net/sox.html}{SOX} instead). Default is \code{NULL} (e.g. keep original sampling rate).}

\item{parallel}{Numeric. Controls whether parallel computing is applied. 
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{path}{Character string containing the directory path where the .mp3 files are located.
If \code{NULL} (default) then the current working directory is used.}

\item{dest.path}{Character string containing the directory path where the .wav files will be saved. 
If \code{NULL} (default) then the folder containing the sound files will be used.}

\item{bit.depth}{Character string containing the units to be used for amplitude normalization. Check 
\code{\link[tuneR]{normalize}} for details. Default is 16.}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}

\item{overwrite}{Logical. Control whether a .wav sound file that is already in the working directory should be 
overwritten.}
}
\value{
.wav files saved in the working directory with same name as original mp3 files.
}
\description{
\code{mp32wav} converts several .mp3 files in working directory to .wav format
}
\details{
The function will convert all mp3 files in  working directory or 'path' supplied to wav format. \href{https://cran.r-project.org/package=bioacoustics}{bioacoustics package} must be installed when changing sampling rates (i.e. if 'samp.rate' is supplied). Note that sound files are normalized using \code{\link[tuneR]{normalize}} so they can be written by \code{\link[tuneR]{writeWave}}.

convert all .mp3 files in working directory to .wav format. Function used internally to read .mp3 files (\code{\link[tuneR]{readMP3}}) sometimes crashes.
}
\examples{
\dontrun{
# download mp3 files from xeno-canto
querxc(qword = "Phaethornis aethopygus", download = TRUE, path = tempdir())

# Convert all files to .wav format
mp32wav(path = tempdir(), dest.path = tempdir())

#check this folder!!
tempdir()
}

}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr}) and Grace Smith Vidaurre
}
