% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rm_channels.R
\name{rm_channels}
\alias{rm_channels}
\title{Remove channels in wave files}
\usage{
rm_channels(files = NULL, channels, path = NULL, parallel = 1, pb = TRUE)
}
\arguments{
\item{files}{Character vector indicating the files that will be analyzed. If not provided. Optional.
then all wave files in the working directory (or path) will be processed.}

\item{channels}{Numeric vector indicating the index (or channel number) for the channels that will be kept (left = 1, right = 2; 3 to inf for multichannel sound files).}

\item{path}{Character string containing the directory path where the sound files are located. 
If \code{NULL} (default) then the current working directory is used.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{pb}{Logical argument to control progress bar and messages. Default is \code{TRUE}.}
}
\value{
Sound files that have been converted are saved in the new 
folder "converted_sound_files". If `img = TRUE` then spectrogram images highlighting the silence segments 
that were removed are also saved.
}
\description{
\code{rm_channels} remove channels in wave files
}
\details{
The function removes channels from wave files. It works on regular and 
multichannel wave files. Converted files are saved in a new directory ("converted_sound_files") 
and original files are not modified.
}
\examples{
{
# save sound file examples
data("Phae.long1")
Phae.long1.2 <- stereo(Phae.long1, Phae.long1)

writeWave(Phae.long1.2, file.path(tempdir(), "Phae.long1.2.wav"))

rm_channels(channels = 1, path = tempdir())

#check this floder
tempdir()
}

}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\seealso{
\code{\link{fixwavs}}, \code{\link{rm_sil}},
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
