% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLegislationSigned.R
\name{getLegislationSigned}
\alias{getLegislationSigned}
\title{Get all bills signed into law}
\usage{
getLegislationSigned(
  biennium,
  agency = c("House", "Senate"),
  paired = FALSE,
  type = c("df", "list", "xml")
)
}
\arguments{
\item{biennium}{Character vector representing the biennium(s) to be
searched. Each argument should take the form "XXXX-YY"}

\item{agency}{One of "House" or "Senate", or a vector with these as its
elements.}

\item{paired}{If TRUE, will assume that equal length vectors represent
paired data. Set to FALSE to generate an NxN grid of input
arguments. Applies to equal length vector inputs only.}

\item{type}{One of "df", "list", or "xml". Specifies the format for
the output.}
}
\value{
\code{getLegislationSigned} returns an object of type equal to the
\code{type} argument (defaults to dataframe)
}
\description{
Get a dataframe containing all of the bills that originated in a
given chamber and were eventually signed into law
}
\examples{
## get all bills signed into law from the Senate between 2007-2010
bienniums <- c("2007-08", "2009-10")
getLegislationSigned(bienniums, "Senate")
}
