% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waveformvoxel.R
\name{waveformvoxel}
\alias{waveformvoxel}
\title{waveformvoxel}
\usage{
waveformvoxel(hpc, res = c(0.8, 0.8, 0.15), quan = NULL)
}
\arguments{
\item{hpc}{the objetcs from hyperpointcloud function.}

\item{res}{the voxel size with x, y, and z spatial resolution. Default is 0.8*0.8*0.15.}

\item{quan}{The quantile of intenisty in the given grid or voxel. Defalut is NULL.}
}
\value{
A dataframe with 7 columns including geolocation and intensities. Specifically,"index","cx","cy","length_maxi_meani_totali.1","length_maxi_meani_totali.2",
  "length_maxi_meani_totali.3","length_maxi_meani_totali.4").
  \item{index}{The index of the voxel}
  \item{cx}{The average x of the voxel center}
  \item{cy}{The average y of the voxel center}
  \item{cz}{The average z of the voxel center}
  \item{intensity.length}{The number of intensity in the voxel}
  \item{intensity.maxi}{The maximum intensity of waveforms in the voxel}
  \item{intensity.meani}{The mean intensity of waveforms in the voxel}
  \item{intensity.totali}{The total intensity of waveforms in the voxel}
  \item{...}{Percentile intensity based on the quan}
}
\description{
The function allows you to project raw waveforms into 3d voxels from hyperpointcloud with self defined resolution.
  For the intensity of each grid, four kinds of values were available to be used: the total number of intensity in each voxel,
  maximum intensity of the voxel, mean intensity of the voxel, and total intensity of the voxel.
}
\examples{

data(return)  ###import raw return waveforms
data(geo)  ###import corresponding reference geolocation

#' ### you should know which columns corresponding to above column names
## before run the hyperpointcloud when you used your own new datasets, this is very important step
colnames(geo)[2:9]<-c("x","y","z","dx","dy","dz","or","fr")

hpr<- hyperpointcloud(waveform = return,geo = geo)

##beofre run waveformvoxel, we need to create hyperpointcloud first
##this exampel we just used 100000 points to reduce processing time

voxr<-waveformvoxel(hpc = hpr,res=c(1,1,0.3))

}
\references{
Tan Zhou, Sorin Popescu, Lonesome Malambo, Kaiguang Zhao, Keith Krause. From LiDAR waveforms
  to Hyper Point Clouds: a novel data product to characterize vegetation structure.
  Remote Sensing 2018, 10(12), 1949; https://doi.org/10.3390/rs10121949
}
