% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cls_wdnet.R
\name{adj_to_wdnet}
\alias{adj_to_wdnet}
\title{Creates a \code{wdnet} object using an adjacency matrix}
\usage{
adj_to_wdnet(adj, directed = TRUE, weighted = TRUE, nodegroup, ...)
}
\arguments{
\item{adj}{An adjacency matrix used to extract \code{edgelist} and
\code{edgeweight} using \code{igraph}.}

\item{directed}{Logical, whether the network is directed (TRUE) or undirected
(FALSE). If \code{adj} is asymmetric, the network is directed.}

\item{weighted}{Logical, whether the network is weighted (TRUE) or unweighted
(FALSE).}

\item{nodegroup}{A numeric vector of node groups.}

\item{...}{Additional components to be added to the \code{wdnet} object.}
}
\value{
A \code{wdnet} object with the specified \code{adj}.
}
\description{
Creates a \code{wdnet} object using an adjacency matrix
}
\examples{
adj <- matrix(c(0, 1, 2, 0), nrow = 2, ncol = 2, byrow = TRUE)
adj_to_wdnet(adj = adj, directed = TRUE, weighted = FALSE)

}
