\name{getDailyMinMaxTemp}
\alias{getDailyMinMaxTemp}
\title{Get the daily minimum (maximum) temperatures for a given weather stations}
\usage{
getDailyMinMaxTemp(station_id, start_date, end_date = NULL,
  daily_min = TRUE, daily_max = TRUE, station_type = "airportCode",
  opt_write_to_file = FALSE)
}
\arguments{
  \item{station_id}{is a valid 3- or 4-letter Airport code
  or a valid Weather Station ID (example: "BUF", "ORD",
  "VABB" for Mumbai).  Valid Weather Station "id" values:
  "KFLMIAMI75" or "IMOSCOWO2" You can look these up at
  wunderground.com}

  \item{start_date}{is a valid string representing a date
  in the past (YYYY-MM-DD, all numeric)}

  \item{end_date}{(optional) If an interval is to be
  specified, end_date is a a valid string representing a
  date in the past (YYYY-MM-DD, all numeric) and greater
  than start_date}

  \item{daily_min}{A boolean indicating if the Minimum
  Temperatures are desired}

  \item{daily_max}{A boolean indicating if the Maximum
  Temperatures are desired Both \code{daily_min} and
  \code{daily_max} can be TRUE, but at least one of them
  should be TRUE.}

  \item{station_type}{= "airportCode" or "ID" (Wx call
  Sign)}

  \item{opt_write_to_file}{If TRUE, the resulting dataframe
  will be stored in a CSV file.  Default is FALSE}
}
\value{
A data frame with each row containing: \itemize{ \item Date
and Time stamp (for when that day's minimum temperature was
recorded) \item Minimum Temperature for the station in
Farenheit (or Celcius) \item Date and Time stamp (for when
that day's maximum temperature was recorded) \item Maximum
Temperature for the station in Farenheit (or Celcius) }
}
\description{
Given a StationID and a set of dates, this function returns
the Daily Minimum and/or Maximum temperatures recorded,
along with timestamps
}
\details{
This functions fetches all the records for each date
specified, but it only retaints the min and/or max record,
along with the timestamp.
}
\examples{
\dontrun{
dat <- getDailyMinMaxTemp("KIAH", "2013-08-10", 2013-08-31", daily_max=TRUE)
dat <- getDailyMinMaxTemp("KBIL", "2013-08-10", daily_max=T)
dat <- getDailyMinMaxTemp("EGLL", "2013-08-10", daily_max=T, daily_min=TRUE)
}
}

