% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemspider.R
\name{get_csid}
\alias{get_csid}
\title{Retrieve ChemSpider ID}
\usage{
get_csid(query, token = NULL, first = TRUE, verbose = TRUE, ...)
}
\arguments{
\item{query}{charachter; search term.}

\item{token}{character; your security token.}

\item{first}{logical; If TRUE (default) return only first result.}

\item{verbose}{logical; should a verbose output be printed on the console?}

\item{...}{currently not used.}
}
\value{
if first = TRUE a character vector with ChemSpider IDs, otherwise a list.
}
\description{
Return Chemspider ID (CSID) for a search query, see \url{https://www.chemspider.com/}.
}
\note{
A security token is neeeded. Please register at RSC.
\url{https://www.rsc.org/rsc-id/register}
for a security token.
Please respect the Terms & conditions \url{https://www.rsc.org/help-legal/legal/terms-conditions/}.
}
\examples{
\dontrun{
# Fails because no TOKEN is included
token <- '<YOUR-SECURITY-TOKEN>'
get_csid("Triclosan", token = token)[[1]]
# [1] "5363"
get_csid(c("Triclosan", "50-00-0"), token = token)
}
}
\seealso{
\code{\link{cs_compinfo}} and \code{\link{cs_extcompinfo}} to
retrieve compound details from csid.
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}
