% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{is.inchikey_format}
\alias{is.inchikey_format}
\title{Check if input is a valid inchikey using format}
\usage{
is.inchikey_format(x, verbose = TRUE)
}
\arguments{
\item{x}{character; input string}

\item{verbose}{logical; print messages during processing to console?}
}
\value{
a logical
}
\description{
Inchikey must fulfill the following criteria:
1) consist of 27 characters;
2) be all uppercase, all letters (no numbers);
3) contain two hyphens at positions 15 and 26;
4) 24th character (flag character) be 'S' (Standard InChI) or 'N'
(non-standard)
5) 25th character (version character) must be 'A' (currently).
}
\examples{
\donttest{
# might fail if API is not available
is.inchikey_format('BQJCRHHNABKAKU-KBQPJGBKSA-N')
is.inchikey_format('BQJCRHHNABKAKU-KBQPJGBKSA')
is.inchikey_format('BQJCRHHNABKAKU-KBQPJGBKSA-5')
is.inchikey_format('BQJCRHHNABKAKU-KBQPJGBKSA-n')
is.inchikey_format('BQJCRHHNABKAKU/KBQPJGBKSA/N')
is.inchikey_format('BQJCRHHNABKAKU-KBQPJGBKXA-N')
is.inchikey_format('BQJCRHHNABKAKU-KBQPJGBKSB-N')
}
}
\seealso{
\code{\link{is.inchikey}} for a pure-R implementation.
}
\author{
Eduard Szöcs, \email{eduardszoecs@gmail.com}
}
