% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_layout}
\alias{plot_layout}
\title{Layout of the Probability Plot}
\usage{
plot_layout(x, distribution = c("weibull", "lognormal", "loglogistic",
  "normal", "logistic", "sev"), title_main = "Probability Plot",
  title_x = "Characteristic", title_y = "Unreliability")
}
\arguments{
\item{x}{a numeric vector which consists of lifetime data. \code{x} is used to
specify the grid of the plot.}

\item{distribution}{supposed distribution of the random variable. The
value can be \code{"weibull"}, \code{"lognormal"}, \code{"loglogistic"},
\code{"normal"}, \code{"logistic"} or \code{"sev"} \emph{(smallest extreme value)}.
Other distributions have not been implemented yet.}

\item{title_main}{a character string which is assigned to the main title
of the plot.}

\item{title_x}{a character string which is assigned to the title of the
x axis.}

\item{title_y}{a character string which is assigned to the title of the
y axis.}
}
\value{
Returns a plotly object which contains the layout
  that is used for probability plotting.
}
\description{
This function is used to create the layout of a probability plot.
}
\examples{
# Example 1: Weibull-Grid:
x_layout <- seq(1e-5, 1e+07, length.out = 10)
grid_weibull <- plot_layout(x = x_layout,
                            distribution = "weibull",
                            title_main = "Weibull Analysis",
                            title_x = "Time to Failure",
                            title_y = "Failure Probability in \%")

# Example 2: Grid of Normal Distribution:
x_layout <- seq(1, 10, length.out = 10)
grid_normal <- plot_layout(x = x_layout,
                            distribution = "normal",
                            title_main = "Normal Grid",
                            title_x = "Time to Event",
                            title_y = "Failure Probability in \%")
}
