% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domain_metadata.R
\name{domain_rank}
\alias{domain_rank}
\title{Identify a Domain's Search Ranking}
\usage{
domain_rank(token, domain, ...)
}
\arguments{
\item{token}{a token generated with \code{\link{whoapi_token}}}

\item{domain}{a domain name}

\item{...}{further arguments to pass to httr's GET.}
}
\description{
\code{domain_rank} provides users with the ability
to identify a domain's "search ranking" - how prominent it is
according to common internet benchmarks. Specifically, it provides
both Alexa reach and popularity scores, and the Google Pagerank ("pr")
ranking, which goes from 0 to 10 (and is represented by -1 if it
cannot be found).
}
\examples{
token <- whoapi_token("demokey")
\dontrun{
whoapi_domain <- domain_rank(token, "whoapi.com")
}
}
\seealso{
\code{\link{domain_search}} which specifically
looks at the search results a particular domain pulls up
in various search engines.
}

