% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_basicstats.R
\name{table_basicstats}
\alias{table_basicstats}
\title{Compute basic statistics of the number of members per group per household}
\usage{
table_basicstats(df, hh_id, group_by_var)
}
\arguments{
\item{df}{a data frame of household data where the rows represent members of the households in the sample}

\item{hh_id}{string (length 1) indicating the name of the variable in \code{df} uniquely identifying households}

\item{group_by_var}{string (length 1) to pass to \code{group_by_at()} with name of variable in \code{df} to group results by}
}
\value{
A tibble with rows for each level of \code{group_by_var} and "Total" and columns for the Mean (SD), Median and Range of the number of people in each group per household.
}
\description{
Compute basic statistics of the number of members per group per household
}
\note{
Includes a call to \code{tidyr::complete()}, which causes the function to be a bit slow.
}
\examples{
table_basicstats(df_adults, "HHID", "age_cat")
}
\seealso{
Other table functions: 
\code{\link{table_unweightedpctn}()},
\code{\link{table_weightedpct}()}
}
\concept{table functions}
