% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_utils.R
\name{w_SearchByAuthority}
\alias{w_SearchByAuthority}
\title{Get entities that have identifier in a database or authorities' catalog.}
\usage{
w_SearchByAuthority(
  Pauthority,
  langsorder = "",
  instanceof = "",
  nlimit = 10000,
  debug = FALSE
)
}
\arguments{
\item{Pauthority}{Wikidata property identifier of the database or
authorities' catalog. For example, if Pauthority = "P4439", all entities
which have an identifier in the MNCARS (Museo Nacional Centro de Arte Reina
Sofía) database are returnd. Following libraries abbreviation for the
databases can be also used in the parameter 'Pauthority':

library   : VIAF, LC,   BNE , ISNI, JPG,  ULAN, BNF,  GND, DNB,
Pauthority: P214, P244, P950, P213, P245, P245, P268, P227,P227,

library   : SUDOC, NTA,  J9U,   ELEM,  NUKAT, MNCARS
Pauthority: P269, P1006, P8189, P1565, P1207, P4439}

\item{langsorder}{Order of languages in which the information will be
returned, separated with '|'. If no information is given in the first
language, next is used. If langsorder=='', then labels or descriptions are
not returned.}

\item{instanceof}{Wikidata entity of which the entities searched for are an
example or member of it (class). Optional. For example, if instanceof="Q5"
the search are filtered to Wikidata entities of class Q5 (human). Some
entity classes are allowed, separated with '|'.}

\item{nlimit}{If the number of entities in the database or authorities'
catalog exceeds this number, then query are made in chunks. The value can
increase if langorder=''. Please, reduce the default value if error is raised.}

\item{debug}{For debugging purposes (default FALSE). If debug='info'
information about chunked queries is shown. If debug='query' also the query
launched is shown. If debug='count' the function only returns the number of
entities with have identifier in that authority.}
}
\value{
A data-frame with columns: 'entity', 'entityLabel', 'entityDescription',
'instanceof', instanceofLabel' and the identifier in the "Pauthority" database.
Index of the data-frame is also set to the list of entities found.
}
\description{
Get all Wikidata entities that have identifier in the database or
authorities' catalog indicated in the parameter \code{Pauthority}. Returns the
Wikidata entities. If parameter \code{langsorder}='', then no labels or
descriptions of the entities are returned, otherwise the function returns
them in the language order indicated in \code{langsorder}. Filtering is possible
if parameter \code{instanceof}!=''.
If only the number of entities which have identifier in the database or
authorities' catalog is needed, set \code{debug}='count'.
}
\examples{
\dontrun{
# Example: Pauthority=P4439 (has identifier in the Museo Nacional Centro de
# Arte Reina Sofía)
w_SearchByAuthority(Pauthority="P4439", debug='count')
mncars <- w_SearchByAuthority(Pauthority="P4439")
mncars <- w_SearchByAuthority(Pauthority="MNCARS", langsorder = 'es|en')
# Wikidata entities are not 'human' (Q5):
mncars[!grepl("\\\\bQ5\\\\b", mncars$instanceof), ]
# Wikidata entities are 'human' (Q5):
mncars <- w_SearchByAuthority(Pauthority="MNCARS", langsorder = 'es|en', instanceof='Q5')
}
}
\author{
Angel Zazo, Department of Computer Science and Automatics, University of Salamanca
}
