% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_random_search.R
\name{plot_random_search}
\alias{plot_random_search}
\title{Plot the result of a randomized output.}
\usage{
plot_random_search(resultRS, result, Polygon1, best)
}
\arguments{
\item{resultRS}{The result of the random functions
\code{\link{random_search_single}} and \code{\link{random_search}}.}

\item{result}{The result of the function \code{\link{genetic_algorithm}} or
\code{\link{windfarmGA}}}

\item{Polygon1}{The Polygon for the wind farm area.}

\item{best}{How many best candidates to plot. Default is 1.}
}
\description{
Plotting method for the results of
  \code{\link{random_search_single}} and \code{\link{random_search}}.
}
\examples{
\donttest{
load(file = system.file("extdata/resultrect.rda", package = "windfarmGA"))
load(file = system.file("extdata/polygon.rda", package = "windfarmGA"))

Res = random_search(result = resultrect, Polygon1 = polygon)
plot_random_search(resultRS = Res, result = resultrect, Polygon1 = polygon, best=2)
}
}
\seealso{
Other Randomization: \code{\link{random_search_single}},
  \code{\link{random_search}}
}
\concept{Randomization}
