% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wish_psn.R
\name{wish_psn}
\alias{wish_psn}
\title{Coefficient Matrix \eqn{\mathcal{H}_k}}
\usage{
wish_psn(k, n, alpha = 2)
}
\arguments{
\item{k}{The order of the \eqn{\mathcal{H}_k} matrix}

\item{n}{The degrees of freedom of \eqn{W}}

\item{alpha}{The type of Wishart distribution (\eqn{\alpha = 2/\beta}):
\itemize{
\item 1/2: Quaternion Wishart
\item 1: Complex Wishart
\item 2: Real Wishart (default)
}}
}
\value{
A coefficient matrix \eqn{\mathcal{H}_k} that allows us to compute
the expected value of a power-sum symmetric function of \eqn{W},
where \eqn{W \sim W_m^{\beta}(n,\Sigma)}.
}
\description{
This function computes the coefficient matrix \eqn{\mathcal{H}_k} that allows us to compute
the expected value of a power-sum symmetric function of \eqn{W}, where
\eqn{W \sim W_m^{\beta}(n,\Sigma)}.
}
\examples{
# Example 1:
wish_psn(3, 10) # For real Wishart distribution with k = 3 and n = 10

# Example 2:
wish_psn(4, 10, 1) # For complex Wishart distribution with k = 4 and n = 10

# Example 3:
wish_psn(2, 10, 1/2) # For quaternion Wishart distribution with k = 2 and n = 10
}
