% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{wk_format}
\alias{wk_format}
\alias{wkt_format_handler}
\title{Format well-known geometry for printing}
\usage{
wk_format(handleable, precision = 7, trim = TRUE, max_coords = 6, ...)

wkt_format_handler(precision = 7, trim = TRUE, max_coords = 6)
}
\arguments{
\item{handleable}{A geometry vector (e.g., \code{\link[=wkb]{wkb()}}, \code{\link[=wkt]{wkt()}}, \code{\link[=xy]{xy()}},
\code{\link[=rct]{rct()}}, or \code{\link[sf:sfc]{sf::st_sfc()}}) for which \code{\link[=wk_handle]{wk_handle()}} is defined.}

\item{precision}{If \code{trim} is \code{TRUE}, the total number of significant digits to keep
for each result or the number of digits after the decimal place otherwise.}

\item{trim}{Use \code{FALSE} to keep trailing zeroes after the decimal place.}

\item{max_coords}{The maximum number of coordinates to include
in the output.}

\item{...}{Passed to the \code{\link[=wk_handle]{wk_handle()}} method.}
}
\value{
A character vector of abbreviated well-known text.
}
\description{
Provides an abbreviated version of the well-known text
representation of a geometry. This returns a constant
number of coordinates for each geometry, so is safe to
use for geometry vectors with many (potentially large)
features. Parse errors are passed on to the format string
and do not cause this handler to error.
}
\examples{
wk_format(wkt("MULTIPOLYGON (((0 0, 10 0, 0 10, 0 0)))"))
wk_format(new_wk_wkt("POINT ENTPY"))
wk_handle(
  wkt("MULTIPOLYGON (((0 0, 10 0, 0 10, 0 0)))"),
  wkt_format_handler()
)

}
