% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-version.R
\name{wood_core_version}
\alias{wood_core_version}
\title{Get current version of a core R package}
\usage{
wood_core_version(package)
}
\arguments{
\item{package}{\code{character(1)}\cr
Name of a package to query for.}
}
\value{
A single string with a version code. Should be equal to the R version
(\code{\link[base:numeric_version]{base::getRversion()}}).
}
\description{
This function checks the version of the selected core R package.
}
\examples{
wood_core_version("graphics")

}
\seealso{
Functions for core R packages:
\code{\link{wood_core_dependencies}()},
\code{\link{wood_core_packages}()}

Functions that query package versions:
\code{\link{wood_bioc_version}()},
\code{\link{wood_cran_latest}()},
\code{\link{wood_cran_versions}()},
\code{\link{wood_github_latest}()},
\code{\link{wood_github_versions}()},
\code{\link{wood_local_versions}()},
\code{\link{wood_runiverse_version}()},
\code{\link{wood_url_version}()},
\code{\link{wood_versions}()}
}
\concept{core}
\concept{versions}
