% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github-packages.R
\name{wood_github_packages}
\alias{wood_github_packages}
\title{List available package on a Github account}
\usage{
wood_github_packages(user, include_forks = FALSE)
}
\arguments{
\item{user}{\code{character(1)}\cr
Name of a user or organization.}

\item{include_forks}{\code{logical(1)}\cr
Whether to include packages forked from other accounts.}
}
\value{
A character vector of available packages.
}
\description{
This function finds packages among repositories belonging to a
selected account. They are returned as a vector of strings, each element
being a repository (and in most cases, package) name.
}
\examples{
\donttest{
wood_github_packages("turtletopia")
# I moved most my packages to turtletopia
wood_github_packages("ErdaradunGaztea", include_forks = TRUE)
}

}
\seealso{
Functions for GitHub:
\code{\link{wood_github_dependencies}()},
\code{\link{wood_github_latest}()},
\code{\link{wood_github_tags}()},
\code{\link{wood_github_versions}()}

Functions that query available packages:
\code{\link{wood_bioc_packages}()},
\code{\link{wood_core_packages}()},
\code{\link{wood_cran_packages}()},
\code{\link{wood_local_packages}()},
\code{\link{wood_packages}()},
\code{\link{wood_runiverse_packages}()},
\code{\link{wood_url_packages}()}
}
\concept{github}
\concept{packages}
