% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/url-dependencies.R
\name{wood_url_dependencies}
\alias{wood_url_dependencies}
\title{Get dependencies of a package in any repository}
\usage{
wood_url_dependencies(package, repository)
}
\arguments{
\item{package}{\code{character(1)}\cr
Name of a package to query for.}

\item{repository}{\code{character(1)}\cr
URL to repository, e.g. \code{"http://www.omegahat.net/R"}.}
}
\value{
A data frame with three columns, all in string format:
\itemize{
\item \code{package} (package name),
\item \code{version} (minimum version requirement or \code{NA} if none),
\item \code{type} (dependency type, e.g. \code{"Imports"}).
}
}
\description{
This function queries any online repository for dependencies of
the selected package.
}
\examples{
\donttest{
wood_url_dependencies("XML", repository = "http://www.omegahat.net/R")
}

}
\seealso{
Functions for any URL:
\code{\link{wood_url_packages}()},
\code{\link{wood_url_version}()}

Functions that query package dependencies:
\code{\link{wood_bioc_dependencies}()},
\code{\link{wood_core_dependencies}()},
\code{\link{wood_cran_dependencies}()},
\code{\link{wood_dependencies}()},
\code{\link{wood_github_dependencies}()},
\code{\link{wood_local_dependencies}()},
\code{\link{wood_runiverse_dependencies}()}
}
\concept{dependencies}
\concept{url}
