% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_load.R
\name{notify_synthetic}
\alias{notify_synthetic}
\title{Notify the user when synthetic data are being used}
\usage{
notify_synthetic(..., msg = NULL)
}
\arguments{
\item{...}{Objects of class \code{worcs_data}. The function will check if
these are original or synthetic data.}

\item{msg}{Expression containing the message to print in case not all
\code{worcs_data} are original. This message may refer to \code{is_synth},
a logical vector indicating which \code{worcs_data} objects are synthetic.}
}
\value{
No return value. This function is called for its side effect of
printing a notification message.
}
\description{
This function prints a notification message when some or all of
the data used in a project are synthetic (see \code{\link{closed_data}} and
\code{\link{synthetic}}). See details for important information.
}
\details{
The preferred way to use this function is to provide specific data
objects in the function call, using the \code{...} argument.
If no such objects are provided, \code{notify_synthetic} will scan the
parent environment for objects of class \code{worcs_data}.

This function is emphatically designed to be included in an 'R Markdown'
file, to dynamically generate a notification message when a third party
'Knits' such a document without having access to all original data.
}
\examples{
df <- iris
class(df) <- c("worcs_data", class(df))
attr(df, "type") <- "synthetic"
notify_synthetic(df, msg = "synthetic")
}
\seealso{
closed_data synthetic add_synthetic
}
