% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{option_add}
\alias{option_add}
\alias{option_remove}
\alias{option_add_parameters}
\title{Add and edit options saved in a workflow set}
\usage{
option_add(x, ..., id = NULL, strict = FALSE)

option_remove(x, ...)

option_add_parameters(x, id = NULL, strict = FALSE)
}
\arguments{
\item{x}{A workflow set}

\item{...}{A list of named options. For \code{option_remove()} this can be a
series of unquoted option names.}

\item{id}{A character string of one or more values from the \code{wflow_id}
column that indicates which options to update. By default, all workflows
are updated.}

\item{strict}{A logical; show execution stop if existing options are being
replaced?}
}
\value{
An updated workflow set.
}
\description{
These functions are helpful for manipulating the information in the \code{option}
column.
}
\details{
\code{option_add()} is used to update all of the options in a workflow set.

\code{option_remove()} will eliminate specific options across rows.

\code{option_add_parameters()} adds a parameter object to the \code{option} column
(if parameters are being tuned).

Note that executing a function on the workflow set, such as \code{tune_grid()},
will add any options given to that function to the \code{option} column.
}
\examples{
two_class_set \%>\%
  option_add(a = 1)

two_class_set \%>\%
  option_add(a = 1) \%>\%
  option_add(b = 2, id = "none_cart")

library(tune)
two_class_set \%>\%
  option_add_parameters()
}
