% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_advanced_match_stats.R
\name{get_advanced_match_stats}
\alias{get_advanced_match_stats}
\title{Get advanced match stats}
\usage{
get_advanced_match_stats(match_url, stat_type, team_or_player, time_pause = 3)
}
\arguments{
\item{match_url}{the three character country code for all countries}

\item{stat_type}{the type of team statistics the user requires}

\item{team_or_player}{result either summarised for each team, or individual players}

\item{time_pause}{the wait time (in seconds) between page loads

The statistic type options (stat_type) include:

\emph{"summary"}, \emph{"passing"}, \emph{"passing"_types},
\emph{"defense" }, \emph{"possession"}, \emph{"misc"}, \emph{"keeper"}}
}
\value{
returns a dataframe of a selected team statistic type for a selected match(es)
}
\description{
Returns data frame of selected statistics for each match, for either whole team or individual players.
Multiple URLs can be passed to the function, but only one `stat_type` can be selected
}
\examples{
\dontrun{
try({
urls <- get_match_urls(country = "AUS", gender = "F", season_end_year = 2021, tier = "1st")

df <- get_advanced_match_stats(match_url=urls,stat_type="possession",team_or_player="player")
})
}
}
