% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read_wos_data}
\alias{read_wos_data}
\title{Read WoS data}
\usage{
read_wos_data(dir)
}
\arguments{
\item{dir}{Path the directory where you wrote the CSV files.}
}
\value{
An object of class \code{wos_data}.
}
\description{
Reads in a series of CSV files (which were written via
\code{\link{write_wos_data}}) and places the data in an object of class
\code{wos_data}.
}
\examples{
\dontrun{

sid <- auth("your_username", password = "your_password")
wos_data <- pull_wos("TS = (dog welfare) AND PY = 2010", sid = sid)

# Write files to working directory
write_wos_data(wos_data, ".")
# Read data back into R
wos_data <- read_wos_data(".")
}
}
