% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seaRoll.R
\name{seaRoll}
\alias{seaRoll}
\title{Rolling Seasonal Kendall trend test}
\usage{
seaRoll(x, w = 10, plot = FALSE, pval = 0.05, mval = 0.5, pchs = c(19,
  21), xlab = NULL, ylab = NULL, ...)
}
\arguments{
\item{x}{A seasonal time series vector.}

\item{w}{The window width for \dQuote{rolling} estimates of slope.}

\item{plot}{Indicates if a plot should be drawn}

\item{pval}{p-value for significance}

\item{mval}{Minimum fraction of seasons needed with non-missing slope
estimates}

\item{pchs}{Plot symbols for significant and not significant trend
estimates, respectively}

\item{xlab}{Optional label for x-axis}

\item{ylab}{Optional label for y-axis}

\item{...}{Other arguments to pass to plotting function}
}
\value{
\code{seaRoll} returns a matrix with one row per time window
containing the Sen slope, the relative Sen slope, and the \emph{p-}value.
Rows are labelled with the leading year of the window.
}
\description{
Calculates the Seasonal Kendall test of significance, including an estimate
of the Sen slope, for rolling windows over a time series.
}
\details{
The function \code{seaRoll} applies \code{seaKen} to rolling time windows of
width \code{w}. A minimum \code{w} of five years is required. For any
window, a season is considered missing if half or more of the possible
comparisons between the first and last 20\% of the years is missing. If
\code{mval} or more of the seasons are missing, then that windowed trend is
considered to be missing.

If \code{plot = TRUE}, a point plot will be drawn with the Sen slope plotted
at the leading year of the trend window. The plot symbols indicate,
respectively, that the trend is significant or not significant. The plot can
be customized by passing any arguments used by \code{\link{plot.default}},
as well as graphical parameters described in \code{\link{par}}.
}
\examples{

chl27 <- sfbayChla[, 's27']
seaRoll(chl27)
seaRoll(chl27, plot = TRUE)

}
\seealso{
\code{\link{seaKen}}
}
\author{
Alan Jassby, James Cloern
}
\keyword{ts}
