% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportSdrfDraft.R
\name{exportSdrfDraft}
\alias{exportSdrfDraft}
\title{Export Sample Meta-data from Quantification-Software as Sdrf-draft}
\usage{
exportSdrfDraft(
  lst,
  fileName = "sdrfDraft.tsv",
  correctFileExtension = TRUE,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{lst}{(list) object created by import-function (MaxQuant)}

\item{fileName}{(character) file-name (and path) to be used when exprting}

\item{correctFileExtension}{(logical) if \code{TRUE} the fileName will get a \code{.tsv}-extension if not already present}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function writes an Sdrf draft to file
}
\description{
Sample/experimental annotation meta-data form \href{https://www.maxquant.org/}{MaxQuant} that was previously import can now be formatted in sdrf-style and exported
using this function to write a draft-sdrf-file.
Sdrf-files provide additional meta-information about samles and MS-runs in a standardized format, they may also be part of submissions to \href{https://www.ebi.ac.uk/pride/}{Pride}.
}
\details{
Gathering information about samples and MS-runs requires that at data-import the additioal files created from software, like MaxQuant, was present and imported.
After exporting the draft sdrf the user is advised to check and complete the information in the resulting file.
Unfortunately, not all information present in a standard sdrf-file (like on \href{https://www.ebi.ac.uk/pride/}{Pride}) cannot be gathered automatically,
but key columns are already present and thus may facilitate completing.
Please note, that the file-format has been defined as \code{.tsv}, thus columns/fields shoud be separated by tabs.
At manual editing and completion, some editing- or tabulator-software may change the file-extesion to \code{.tsv.txt},
in this case the final files should be renamed as \code{.tsv} to remain compatible with Pride.

At this point only the import of data from MaxQuant via \code{\link{readMaxQuantFile}} has been developed to extract information for creating a draft-sdrf.
Other data/file-import functions will be further developed to gather equivalent information in the future.
}
\examples{
path1 <- system.file("extdata", package="wrProteo")
fiNaMQ <- "proteinGroups.txt.gz"
dataMQ <- readMaxQuantFile(path1, file=fiNaMQ, refLi="mainSpe", sdrf=FALSE, suplAnnotFile=TRUE)
## Here we'll write simply in the current temporary directory of this R-session
exportSdrfDraft(dataMQ, file.path(tempdir(),"testSdrf.tsv"))

}
\seealso{
This function may be used after reading/importig data by \code{\link{readMaxQuantFile}} in absence of sdrf
}
