% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convAASeq2mass.R
\name{convAASeq2mass}
\alias{convAASeq2mass}
\title{Molecular mass for amino-acids}
\usage{
convAASeq2mass(
  x,
  massTy = "mono",
  seqName = TRUE,
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{x}{(character) aminoacid sequence (single upper case letters for describing a peptide/protein)}

\item{massTy}{(character) default 'mono' for mono-isotopic masses (alternative 'average')}

\item{seqName}{(logical) optional (alternative) names for the content of 'x' (ie aa seq) as name (always if 'x' has no names)}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
This functions returns a vector with masses for all amino-acids (argument 'massTy' to switch form mono-isotopic to average mass)
}
\description{
This function calculates the molecular mass of one-letter code amion-acid sequences.
}
\examples{
convAASeq2mass(c("PEPTIDE","fPROTEINES"))
pep1 <- c(aa="AAAA", de="DEFDEF")
convAASeq2mass(pep1, seqN=FALSE)
}
\seealso{
\code{\link{massDeFormula}}, \code{\link{AAmass}}, \code{\link[wrMisc]{convToNum}}
}
