% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fragmentSeq.R
\name{fragmentSeq}
\alias{fragmentSeq}
\title{Fragment protein or peptide sequence}
\usage{
fragmentSeq(
  sequ,
  minSize = 3,
  maxSize = 300,
  internFragments = TRUE,
  separTerm = FALSE,
  keepRedSeqs = TRUE,
  prefName = NULL,
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{sequ}{(character, length=1) sequence used for fragmenting, as as mono-aminoacid letter code (so that cuting will be perfomed between all the letters/characters)}

\item{minSize}{(integer) min number of AA residues for considering peptide fragments}

\item{maxSize}{(integer) max number of AA residues for considering peptide fragments}

\item{internFragments}{(logical) logical (return only terminal fragments if 'FALSE')}

\item{separTerm}{(logical) if 'TRUE', separate N-terminal, C-terminal and internal fragments in list}

\item{keepRedSeqs}{(logical) if 'FALSE' remove fragments with redundant content (but my be from different origin in 'sequ'); remove redundant so far only when no separation of Nterm/Cterm/intern as list}

\item{prefName}{(logical) alternative name for all fragments (default the sequence itself), avoid separators '.' and '-'}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
numeric vector with mass
}
\description{
Makes internal/terminal fragments of a SINGLE peptide/protein input (as single letter amino-acid code) and returns list of all possible sequences ($full, $Nter, $Cter, $inter).
}
\examples{
fragmentSeq("ABCDE")
fragmentSeq("ABCDE", minSize=3, internFragments=FALSE)
fragmentSeq("ABCDE", minSize=3, internFragments=TRUE)

## Run multiple peptides/proteins
twoPep <- cbind(c("a","ABCABCA"), c("e","EFGEFGEF"))
apply(twoPep, 2, function(x) fragmentSeq(x[2], mi=3, kee=FALSE, sep=TRUE, pre=x[1]))

## Ubiquitin example
P0CG48 <- "MQIFVKTLTGKTITLEVEPSDTIENVKAKIQDKEGIPPDQQRLIFAGKQLEDGRTLSDYNIQKESTLHLVLRLRGG"  
system.time( fra1 <- (fragmentSeq(P0CG48, mi=5, kee=FALSE)))      # < 0.5 sec  

}
\seealso{
\code{\link{makeFragments}};   \code{\link[wrProteo]{convAASeq2mass}}
}
