% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wtss.R
\docType{methods}
\name{listTimeSeries}
\alias{listTimeSeries}
\alias{listTimeSeries,WTSS-method}
\title{Get list of time series}
\usage{
listTimeSeries(object, coverages, attributes, coordinates, start_date, end_date)

\S4method{listTimeSeries}{WTSS}(object, coverages, attributes, coordinates,
  start_date, end_date)
}
\arguments{
\item{object}{Either a WTSS object or a server URL.}

\item{coverages}{Either a list of coverages and attributes such as retrieved by describe_coverage() or a character with the coverage name.}

\item{attributes}{A character vector of dataset names.}

\item{coordinates}{A list or data frame of longitude latitude coordinates in WGS84 coordinate system.}

\item{start_date}{A character with the start date in the format yyyy-mm-dd or yyyy-mm depending on the coverage.}

\item{end_date}{A character with the end date in the format yyyy-mm-dd or yyyy-mm depending on the coverage.}
}
\description{
This function retrieves the time series for a list of coordinates.
}
\examples{
\donttest{
ts.server <-  WTSS("http://www.esensing.dpi.inpe.br/wtss/")
bands <- c("ndvi","evi")
coords <- list (c(-45.00, -12.00), c(-46.00, -11.00))
tsList <- listTimeSeries(ts.server, "MOD13Q1", bands, coords, "2000-02-18", "2016-12-18")
}
}
