% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/master_functions.R
\name{autocorrelation_coeff_plot}
\alias{autocorrelation_coeff_plot}
\title{Plot Confidence Bounds of Estimated Functional Autocorrelation Coefficients}
\usage{
autocorrelation_coeff_plot(
  f_data,
  K = 20,
  alpha = 0.05,
  M = NULL,
  wwn_bound = TRUE
)
}
\arguments{
\item{f_data}{The functional data matrix with observed functions in the columns.}

\item{K}{A positive Integer value. The maximum lag for which to compute the single-lag test (tests
will be computed for lags h in 1:K).}

\item{alpha}{A numeric value between 0 and 1 specifying the significance level to be used in the single-lag
test. The default value is 0.05.}

\item{M}{A positive Integer value. Determines the number of Monte-Carlo simulations employed in the
Welch-Satterthwaite approximation of the limiting distribution of the test statistics, for each test.}

\item{wwn_bound}{A Boolean value allowing the user to turn off the weak white noise bound. TRUE by default.
Speeds up computation when FALSE.}
}
\value{
Plot of the estimated autocorrelation coefficients for lags h in 1:K with the weak
white noise 1-alpha upper  confidence bound for each lag, as well as the constant strong white
noise 1-alpha confidence bound.
}
\description{
`autocorrelation_coeff_plot` Computes the 1-alpha upper confidence bounds for the functional
autocorrelation coefficients at lags h = 1:K under both weak white noise (WWN) and strong white
noise (SWN) assumptions. It plots the coefficients as well as the bounds for all lags h = 1:K.
Note, the SWN bound is constant, while the WWN is dependent on the lag.
}
\details{
This function computes and plots autocorrelation coefficients at lag h, for h in 1:K. It also
computes an estimated asymptotic 1 - alpha confidence bound, under the assumption that the series
forms a weak white noise. Additionally, it computes a similar (constant) bound under the assumption the
series form a strong white noise. Please see the vignette or the references for a more complete treatment.
}
\examples{
b <- brown_motion(75, 40)
autocorrelation_coeff_plot(b)
autocorrelation_coeff_plot(b, M = 200)

}
\references{
[1] Kokoszka P., & Rice G., & Shang H.L. (2017). Inference for the autocovariance of a functional time series
under conditional heteroscedasticity. Journal of Multivariate Analysis, 162, 32-50.
}
