% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_x3p.R
\name{sample_x3p}
\alias{sample_x3p}
\title{Sample from an x3p object}
\usage{
sample_x3p(x3p, m = 2)
}
\arguments{
\item{x3p}{x3p object}

\item{m}{integer value - every mth value is included in the sample}
}
\value{
down-sampled x3p object
}
\description{
Sample from an x3p object
}
\examples{
logo <- read_x3p(system.file("csafe-logo.x3p", package="x3ptools"))
dim(logo$surface.matrix)
# down-sample to one-fourth of the image:
logo4 <- sample_x3p(logo, m=4)
dim(logo4$surface.matrix)
\dontrun{
image_x3p(logo)
image_x3p(logo4)
}
}
