% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.R
\name{xQTLanalyze_getSentinelSnp}
\alias{xQTLanalyze_getSentinelSnp}
\title{Detect sentinel SNPs in a given summary statistis dataset.}
\usage{
xQTLanalyze_getSentinelSnp(
  gwasDF,
  pValueThreshold = 5e-08,
  centerRange = 1e+06,
  mafThreshold = 0.01,
  genomeVersion = "grch38",
  grch37To38 = FALSE
)
}
\arguments{
\item{gwasDF}{A data.frame or a data.table object. Five columns are required (arbitrary column names is supported):

\verb{Col 1}. "snps" (character), , using an rsID (e.g. "rs11966562").

\verb{Col 2}. "chromosome" (character), one of the chromosome from chr1-chr22.

\verb{Col 3}. "postion" (integer), genome position of snp.

\verb{Col 4}. "P-value" (numeric).

\verb{Col 5}. "MAF" (numeric). Allel frequency.

\verb{Col 6}. "beta" (numeric). effect size.

\verb{Col 7}. "se" (numeric). standard error.}

\item{pValueThreshold}{Cutoff of gwas p-value. Default: 5e-8}

\item{centerRange}{SNP-to-SNP distance. Default:1e6}

\item{mafThreshold}{Cutoff of maf to remove rare variants.}

\item{genomeVersion}{Genome version of input file. "grch37" or "grch38" (default).}

\item{grch37To38}{TRUE or FALSE, we recommend converting grch37 to grch38, or using a input file of grch38 directly. Package \code{rtracklayer} is required.}
}
\value{
A data.table object.
}
\description{
Return sentinel snps whose pValue < 5e-8(default) and SNP-to-SNP distance > 1e6 bp.
}
\examples{
\donttest{
url<-"https://master.dl.sourceforge.net/project/exampledata/GLGC.txt"
gwasDF <- data.table::fread(url)
gwasDF <- gwasDF[, .(rsid, chr, position, P, maf, beta, se)]
sentinelSnpDF <- xQTLanalyze_getSentinelSnp(gwasDF)
}
}
