% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{moon_reader}
\alias{moon_reader}
\alias{tsukuyomi}
\title{An R Markdown output format for remark.js slides}
\usage{
moon_reader(
  css = c("default", "default-fonts"),
  self_contained = FALSE,
  seal = TRUE,
  yolo = FALSE,
  chakra = "https://remarkjs.com/downloads/remark-latest.min.js",
  nature = list(),
  ...
)

tsukuyomi(...)
}
\arguments{
\item{css}{A vector of CSS file paths. Two default CSS files
(\file{default.css} and \file{default-fonts.css}) are provided in this
package, which was borrowed from \url{https://remarkjs.com}. If the
character vector \code{css} contains a value that does not end with
\code{.css}, it is supposed to be a built-in CSS file in this package,
e.g., for \code{css = c('default', 'extra.css')}), it means
\code{default.css} in this package and a user-provided \code{extra.css}. To
find out all built-in CSS files, use \code{xaringan:::list_css()}.}

\item{self_contained}{Whether to produce a self-contained HTML file.}

\item{seal}{Whether to generate a title slide automatically using the YAML
metadata of the R Markdown document (if \code{FALSE}, you should write the
title slide by yourself).}

\item{yolo}{Whether to insert the
\href{https://kbroman.wordpress.com/2014/08/28/the-mustache-photo/}{Mustache
 Karl (TM)} randomly in the slides. \code{TRUE} means insert his picture on
one slide, and if you want him to be on multiple slides, set \code{yolo} to
a positive integer or a percentage (e.g. 0.3 means 30\% of your slides will
be the Mustache Karl). Alternatively, \code{yolo} can also be a list of the
form \code{list(times = n, img = path)}: \code{n} is the number of times to
show an image, and \code{path} is the path to an image (by default, it is
Karl).}

\item{chakra}{A path to the remark.js library (can be either local or
remote). Please note that if you use the default remote latest version of
remark.js, your slides will not work when you do not have Internet access.
They might also be broken after a newer version of remark.js is released.
If these issues concern you, you should download remark.js locally (e.g.,
via \code{\link{summon_remark}()}), and use the local version instead.}

\item{nature}{(Nature transformation) A list of configurations to be passed
to \code{remark.create()}, e.g. \code{list(ratio = '16:9', navigation =
list(click = TRUE))}; see
\url{https://github.com/gnab/remark/wiki/Configuration}. Besides the
options provided by remark.js, you can also set \code{autoplay} to a number
(the number of milliseconds) so the slides will be played every
\code{autoplay} milliseconds; alternatively, \code{autoplay} can be a list
of the form \code{list(interval = N, loop = TRUE)}, so the slides will go
to the next page every \code{N} milliseconds, and optionally go back to the
first page to restart the play when \code{loop = TRUE}. You can also set
\code{countdown} to a number (the number of milliseconds) to include a
countdown timer on each slide. If using \code{autoplay}, you can optionally
set \code{countdown} to \code{TRUE} to include a countdown equal to
\code{autoplay}. To alter the set of classes applied to the title slide,
you can optionally set \code{titleSlideClass} to a vector of classes; the
default is \code{c("center", "middle", "inverse")}.}

\item{...}{For \code{tsukuyomi()}, arguments passed to \code{moon_reader()};
for \code{moon_reader()}, arguments passed to
\code{rmarkdown::\link{html_document}()}.}
}
\description{
This output format produces an HTML file that contains the Markdown source
(knitted from R Markdown) and JavaScript code to render slides.
\code{tsukuyomi()} is an alias of \code{moon_reader()}.
}
\details{
Tsukuyomi is a genjutsu to trap the target in an illusion on eye contact.

If you are unfamiliar with CSS, please see the
\href{https://github.com/yihui/xaringan/wiki}{xaringan wiki on Github}
providing CSS slide modification examples.
}
\note{
Do not stare at Karl's picture for too long after you turn on the
  \code{yolo} mode. I believe he has Sharingan.

  Local images that you inserted via the Markdown syntax
  \command{![](path/to/image)} will not be embedded into the HTML file when
  \code{self_contained = TRUE} (only CSS, JavaScript, and R plot files will
  be embedded). You may also download remark.js (via
  \code{\link{summon_remark}()}) and use a local copy instead of the default
  \code{chakra} argument when \code{self_contained = TRUE}, because it may be
  time-consuming for Pandoc to download remark.js each time you compile your
  slides.

  Each page has its own countdown timer (when the option \code{countdown} is
  set in \code{nature}), and the timer is (re)initialized whenever you
  navigate to a new page. If you need a global timer, you can use the
  presenter's mode (press \kbd{P}).
}
\examples{
# rmarkdown::render('foo.Rmd', 'xaringan::moon_reader')
}
\references{
\url{https://naruto.fandom.com/wiki/Tsukuyomi}
}
